import React from 'react'
import { useTheme } from '@mui/material'

const ReferAFriend = () => {
    const theme = useTheme()
    return (
        <svg
            width="244"
            height="127"
            viewBox="0 0 244 127"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clipPath="url(#clip0_3039_9752)">
                <g opacity="0.68">
                    <path
                        opacity="0.47"
                        d="M217.41 59.6485C216.442 50.0398 211.786 40.4168 203.725 33.5382C191.161 22.8204 172.155 20.1187 155.498 22.5964C148.522 23.6345 141.603 25.4723 134.459 24.8929C124.042 24.0504 114.863 18.2631 105.377 14.0257C92.4646 8.25269 77.6619 5.14577 63.9341 7.65904C48.3698 10.5065 35.6066 21.2634 34.0832 35.536C33.3928 42.0023 40.4044 53.3955 38.1905 59.5241C35.9447 65.7415 19.5582 84.7812 19.964 99.2635C20.3661 113.693 24.1389 118.179 29.4741 125.512H203.625C206.946 118.083 209.548 112.139 205.661 102.381C202.554 94.5854 210.993 88.1654 214.26 80.9064C217.168 74.4473 218.122 66.6799 217.413 59.6449L217.41 59.6485Z"
                        fill="#7ED3AB"
                    />
                </g>
                <path
                    opacity="0.41"
                    d="M1.44902 61.0999C-1.8717 54.6052 0.70871 46.653 7.21134 43.3364C13.714 40.0197 26.1925 40.2934 29.5132 46.7881C32.8339 53.2828 22.8255 58.8284 18.736 64.868C13.0342 73.293 4.76974 67.5946 1.44902 61.0999Z"
                    fill="#7ED3AB"
                />
                <path
                    opacity="0.41"
                    d="M229.746 86.2351C232.928 89.6762 233.185 94.6067 230.323 97.2408C227.461 99.8785 220.578 101.055 217.396 97.6141C214.214 94.173 218.528 89.8539 219.496 85.8832C220.848 80.3447 226.564 82.7904 229.746 86.2351Z"
                    fill="#7ED3AB"
                />
                <path
                    opacity="0.41"
                    d="M202.97 8.77239C206.661 6.8279 211.231 8.23917 213.178 11.922C215.124 15.6083 215.067 22.7322 211.377 24.6767C207.686 26.6212 204.436 20.9548 200.948 18.6655C196.083 15.4768 199.279 10.7169 202.97 8.77239Z"
                    fill="#7ED3AB"
                />
                <g opacity="0.43">
                    <path
                        d="M198.198 117.012C199.895 108.587 197.173 101.395 196.496 93.134C195.856 85.3098 198.636 78.7334 200.18 71.2825C201.554 64.6527 201.095 57.1413 199.372 50.6253C197.02 41.7276 191.595 33.4875 183.787 28.4645C171.618 20.6367 155.384 21.561 141.941 26.943C136.311 29.1968 130.858 32.1971 124.825 32.9578C116.03 34.0634 107.471 30.2775 98.9 28.0059C87.2366 24.9132 74.4342 24.6857 63.4292 29.5665C50.9507 35.1014 42.0812 47.5931 43.1169 61.3503C43.5867 67.5854 45.9892 73.7353 45.1385 79.9278C44.2772 86.2092 40.54 91.4633 38.5611 97.3785C35.8633 105.452 35.6177 117.318 39.9563 125.511H195.276C196.614 122.831 197.603 119.962 198.198 117.012Z"
                        fill="#7ED3AB"
                    />
                </g>
                <g opacity="0.47">
                    <path
                        d="M169.315 90.6109C168.82 85.5204 166.436 80.4192 162.303 76.7755C155.865 71.0984 146.13 69.6658 137.595 70.9775C134.022 71.5285 130.477 72.5026 126.815 72.1933C121.476 71.7454 116.774 68.6811 111.916 66.4345C105.299 63.3773 97.7183 61.7314 90.6818 63.0609C82.7057 64.5682 76.1675 70.2701 75.388 77.8313C75.0356 81.2581 78.6269 87.2942 77.4915 90.5434C76.3419 93.8387 67.9457 103.927 68.1522 111.599C68.3586 119.245 70.2913 121.623 73.0247 125.509H162.246C163.948 121.57 165.282 118.424 163.289 113.252C161.698 109.121 166.023 105.719 167.696 101.873C169.183 98.4493 169.674 94.3364 169.311 90.6073L169.315 90.6109Z"
                        fill="#7ED3AB"
                    />
                </g>
                <path
                    d="M241.841 126.631H10.4476C10.138 126.631 9.88525 126.378 9.88525 126.069C9.88525 125.76 10.138 125.507 10.4476 125.507H241.841C242.151 125.507 242.403 125.76 242.403 126.069C242.403 126.378 242.151 126.631 241.841 126.631Z"
                    fill="#7ED3AB"
                />
                <path
                    d="M233.013 75.0353C233.898 75.0353 234.615 74.3191 234.615 73.4356C234.615 72.5521 233.898 71.8359 233.013 71.8359C232.129 71.8359 231.412 72.5521 231.412 73.4356C231.412 74.3191 232.129 75.0353 233.013 75.0353Z"
                    fill="#17014C"
                />
                <path
                    d="M221.624 119.116C222.312 119.116 222.87 118.559 222.87 117.872C222.87 117.184 222.312 116.627 221.624 116.627C220.936 116.627 220.378 117.184 220.378 117.872C220.378 118.559 220.936 119.116 221.624 119.116Z"
                    fill="#039D55"
                />
                <path
                    d="M28.3594 19.5797C29.244 19.5797 29.9611 18.8635 29.9611 17.98C29.9611 17.0966 29.244 16.3804 28.3594 16.3804C27.4749 16.3804 26.7578 17.0966 26.7578 17.98C26.7578 18.8635 27.4749 19.5797 28.3594 19.5797Z"
                    fill="#039D55"
                />
                <path
                    d="M13.2878 113.225C13.2878 114.164 12.5262 114.924 11.5865 114.924C10.6469 114.924 9.88525 114.164 9.88525 113.225C9.88525 112.287 10.6469 111.526 11.5865 111.526C12.5262 111.526 13.2878 112.287 13.2878 113.225Z"
                    fill="#17014C"
                />
                <path
                    d="M18.0373 26.3331C18.3321 26.3331 18.5712 26.0943 18.5712 25.7998C18.5712 25.5053 18.3321 25.2666 18.0373 25.2666C17.7424 25.2666 17.5034 25.5053 17.5034 25.7998C17.5034 26.0943 17.7424 26.3331 18.0373 26.3331Z"
                    fill="#17014C"
                />
                <path
                    d="M154.537 5.16472C154.043 7.47181 151.772 8.94351 149.462 8.44939C147.152 7.95526 145.679 5.68728 146.173 3.38019C146.668 1.07311 148.939 -0.398596 151.249 0.0955257C153.559 0.589648 155.032 2.85763 154.537 5.16472Z"
                    fill="#039D55"
                />
                <path
                    d="M221.984 11.5621C221.834 12.2624 221.144 12.7103 220.443 12.561C219.742 12.4117 219.293 11.7221 219.443 11.0218C219.592 10.3215 220.283 9.87354 220.984 10.0228C221.685 10.1722 222.133 10.8618 221.984 11.5621Z"
                    fill="#FFB54A"
                />
                <path
                    d="M54.7468 3.31014C54.5973 4.01044 53.9068 4.45835 53.2056 4.30905C52.5045 4.15974 52.056 3.47011 52.2055 2.7698C52.355 2.0695 53.0455 1.62159 53.7466 1.77089C54.4478 1.9202 54.8962 2.60984 54.7468 3.31014Z"
                    fill="#FFB54A"
                />
                <path
                    d="M232.682 40.7638C232.532 41.4641 231.842 41.912 231.14 41.7627C230.439 41.6134 229.991 40.9237 230.14 40.2234C230.29 39.5231 230.98 39.0752 231.681 39.2245C232.383 39.3738 232.831 40.0634 232.682 40.7638Z"
                    fill="#039D55"
                />
                <path
                    d="M139.2 9.22794C139.083 9.77894 138.542 10.1273 137.99 10.01C137.438 9.8927 137.09 9.35236 137.207 8.80136C137.325 8.25037 137.866 7.90199 138.417 8.0193C138.969 8.13661 139.318 8.67695 139.2 9.22794Z"
                    fill="#17014C"
                />
                <path
                    d="M122.868 50.5072C134.165 50.5072 143.323 41.3606 143.323 30.0776C143.323 18.7946 134.165 9.64795 122.868 9.64795C111.571 9.64795 102.413 18.7946 102.413 30.0776C102.413 41.3606 111.571 50.5072 122.868 50.5072Z"
                    fill="#1B1B25"
                />
                <path
                    d="M120.712 48.3529C132.009 48.3529 141.167 39.2063 141.167 27.9233C141.167 16.6403 132.009 7.49365 120.712 7.49365C109.415 7.49365 100.257 16.6403 100.257 27.9233C100.257 39.2063 109.415 48.3529 120.712 48.3529Z"
                    fill="#FFB54A"
                />
                <path
                    d="M120.711 44.4185C111.628 44.4185 104.236 37.0386 104.236 27.9631C104.236 18.8876 111.624 11.5078 120.711 11.5078C129.798 11.5078 137.187 18.8876 137.187 27.9631C137.187 37.0386 129.798 44.4185 120.711 44.4185ZM120.711 12.5778C112.215 12.5778 105.303 19.4813 105.303 27.9667C105.303 36.4521 112.215 43.3556 120.711 43.3556C129.207 43.3556 136.119 36.4521 136.119 27.9667C136.119 19.4813 129.207 12.5778 120.711 12.5778Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M119.509 35.3382C118.481 35.2102 117.491 34.9543 116.534 34.5668C115.576 34.1793 114.704 33.6852 113.914 33.088L115.765 30.3899C116.413 30.8804 117.043 31.2857 117.651 31.6092C118.26 31.9327 118.919 32.1673 119.63 32.3059V28.5414C118.776 28.3032 118.029 28.0437 117.392 27.7593C116.751 27.4749 116.221 27.1372 115.804 26.7426C115.384 26.348 115.071 25.8859 114.857 25.3562C114.644 24.8266 114.537 24.2151 114.537 23.5219V23.4757C114.537 22.8145 114.655 22.2138 114.893 21.677C115.132 21.1402 115.466 20.6745 115.9 20.2799C116.335 19.8853 116.861 19.5654 117.477 19.3201C118.093 19.0748 118.773 18.9149 119.516 18.8331V17.4609H121.983V18.8829C122.837 19.0108 123.624 19.217 124.343 19.5121C125.062 19.8036 125.745 20.1804 126.393 20.6354L124.805 23.4046C124.332 23.0882 123.848 22.8074 123.36 22.5657C122.869 22.3204 122.371 22.1355 121.866 22.0076V25.5837C123.666 26.0743 124.976 26.7142 125.788 27.5033C126.603 28.2925 127.009 29.3519 127.009 30.6778V30.724C127.009 31.3888 126.888 31.986 126.642 32.5228C126.396 33.0595 126.058 33.5252 125.62 33.9198C125.186 34.3144 124.659 34.6379 124.044 34.8903C123.428 35.1427 122.741 35.3098 121.983 35.388V37.7306H119.516V35.3382H119.509ZM119.627 21.7943C119.057 21.8725 118.644 22.0431 118.381 22.3026C118.121 22.5621 117.99 22.8821 117.99 23.2624V23.3086C117.99 23.6712 118.1 23.9841 118.321 24.2436C118.541 24.5031 118.975 24.7519 119.623 24.9901V21.7943H119.627ZM121.855 32.4268C122.976 32.2526 123.538 31.7478 123.538 30.9124V30.8662C123.538 30.4574 123.421 30.1197 123.182 29.8602C122.944 29.6007 122.503 29.3519 121.855 29.1137V32.4303V32.4268Z"
                    fill="#1B1B25"
                />
                <path
                    d="M122.868 50.5072C134.165 50.5072 143.323 41.3606 143.323 30.0776C143.323 18.7946 134.165 9.64795 122.868 9.64795C111.571 9.64795 102.413 18.7946 102.413 30.0776C102.413 41.3606 111.571 50.5072 122.868 50.5072Z"
                    fill="#1B1B25"
                />
                <path
                    d="M120.712 48.3529C132.009 48.3529 141.167 39.2063 141.167 27.9233C141.167 16.6403 132.009 7.49365 120.712 7.49365C109.415 7.49365 100.257 16.6403 100.257 27.9233C100.257 39.2063 109.415 48.3529 120.712 48.3529Z"
                    fill="#FFB54A"
                />
                <path
                    d="M120.711 44.4185C111.628 44.4185 104.236 37.0386 104.236 27.9631C104.236 18.8876 111.624 11.5078 120.711 11.5078C129.798 11.5078 137.187 18.8876 137.187 27.9631C137.187 37.0386 129.798 44.4185 120.711 44.4185ZM120.711 12.5778C112.215 12.5778 105.303 19.4813 105.303 27.9667C105.303 36.4521 112.215 43.3556 120.711 43.3556C129.207 43.3556 136.119 36.4521 136.119 27.9667C136.119 19.4813 129.207 12.5778 120.711 12.5778Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M119.509 35.3382C118.481 35.2102 117.491 34.9543 116.534 34.5668C115.576 34.1793 114.704 33.6852 113.914 33.088L115.765 30.3899C116.413 30.8804 117.043 31.2857 117.651 31.6092C118.26 31.9327 118.919 32.1673 119.63 32.3059V28.5414C118.776 28.3032 118.029 28.0437 117.392 27.7593C116.751 27.4749 116.221 27.1372 115.804 26.7426C115.384 26.348 115.071 25.8859 114.857 25.3562C114.644 24.8266 114.537 24.2151 114.537 23.5219V23.4757C114.537 22.8145 114.655 22.2138 114.893 21.677C115.132 21.1402 115.466 20.6745 115.9 20.2799C116.335 19.8853 116.861 19.5654 117.477 19.3201C118.093 19.0748 118.773 18.9149 119.516 18.8331V17.4609H121.983V18.8829C122.837 19.0108 123.624 19.217 124.343 19.5121C125.062 19.8036 125.745 20.1804 126.393 20.6354L124.805 23.4046C124.332 23.0882 123.848 22.8074 123.36 22.5657C122.869 22.3204 122.371 22.1355 121.866 22.0076V25.5837C123.666 26.0743 124.976 26.7142 125.788 27.5033C126.603 28.2925 127.009 29.3519 127.009 30.6778V30.724C127.009 31.3888 126.888 31.986 126.642 32.5228C126.396 33.0595 126.058 33.5252 125.62 33.9198C125.186 34.3144 124.659 34.6379 124.044 34.8903C123.428 35.1427 122.741 35.3098 121.983 35.388V37.7306H119.516V35.3382H119.509ZM119.627 21.7943C119.057 21.8725 118.644 22.0431 118.381 22.3026C118.121 22.5621 117.99 22.8821 117.99 23.2624V23.3086C117.99 23.6712 118.1 23.9841 118.321 24.2436C118.541 24.5031 118.975 24.7519 119.623 24.9901V21.7943H119.627ZM121.855 32.4268C122.976 32.2526 123.538 31.7478 123.538 30.9124V30.8662C123.538 30.4574 123.421 30.1197 123.182 29.8602C122.944 29.6007 122.503 29.3519 121.855 29.1137V32.4303V32.4268Z"
                    fill="#1B1B25"
                />
                <path
                    d="M100.332 27.7097C105.443 27.7097 109.586 23.5717 109.586 18.4672C109.586 13.3626 105.443 9.22461 100.332 9.22461C95.221 9.22461 91.0779 13.3626 91.0779 18.4672C91.0779 23.5717 95.221 27.7097 100.332 27.7097Z"
                    fill="#1B1B25"
                />
                <path
                    d="M99.3559 26.7356C104.467 26.7356 108.61 22.5976 108.61 17.4931C108.61 12.3885 104.467 8.25049 99.3559 8.25049C94.2452 8.25049 90.1021 12.3885 90.1021 17.4931C90.1021 22.5976 94.2452 26.7356 99.3559 26.7356Z"
                    fill="#FFB54A"
                />
                <path
                    d="M99.3569 24.957C95.246 24.957 91.9039 21.6154 91.9039 17.5132C91.9039 13.4109 95.2496 10.0693 99.3569 10.0693C103.464 10.0693 106.81 13.4109 106.81 17.5132C106.81 21.6154 103.464 24.957 99.3569 24.957ZM99.3569 10.5492C95.5129 10.5492 92.3844 13.6739 92.3844 17.5132C92.3844 21.3524 95.5129 24.4771 99.3569 24.4771C103.201 24.4771 106.329 21.3524 106.329 17.5132C106.329 13.6739 103.201 10.5492 99.3569 10.5492Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M98.8121 20.8483C98.3458 20.7914 97.8974 20.6741 97.4667 20.4999C97.0325 20.3257 96.6374 20.1017 96.2815 19.8316L97.1179 18.6087C97.4097 18.8291 97.6945 19.014 97.9721 19.1597C98.2462 19.3055 98.5451 19.4121 98.869 19.4761V17.7733C98.4846 17.6667 98.1465 17.5494 97.8546 17.4178C97.5664 17.2899 97.3243 17.137 97.1357 16.9557C96.9471 16.778 96.8047 16.5682 96.705 16.3301C96.6089 16.0919 96.5591 15.8146 96.5591 15.4982V15.4769C96.5591 15.1783 96.6125 14.9046 96.7193 14.6629C96.826 14.4211 96.9791 14.2078 97.1748 14.0301C97.3706 13.8523 97.6091 13.7066 97.8867 13.5964C98.1643 13.4862 98.4739 13.4116 98.8085 13.376V12.7539H99.9225V13.3973C100.307 13.4542 100.663 13.5502 100.99 13.6817C101.314 13.8132 101.624 13.9839 101.919 14.1901L101.2 15.4449C100.987 15.3027 100.766 15.1747 100.545 15.0645C100.325 14.9543 100.097 14.869 99.8691 14.8122V16.4296C100.684 16.65 101.275 16.9415 101.645 17.297C102.012 17.656 102.197 18.1324 102.197 18.7331V18.7545C102.197 19.0531 102.14 19.3268 102.03 19.5685C101.919 19.8103 101.766 20.0235 101.567 20.2013C101.371 20.379 101.133 20.5248 100.855 20.6421C100.577 20.7558 100.264 20.8305 99.9225 20.866V21.9254H98.8085V20.8447L98.8121 20.8483ZM98.8655 14.7197C98.6092 14.7553 98.4206 14.8335 98.3031 14.9508C98.1857 15.0681 98.1251 15.2139 98.1251 15.3845V15.4058C98.1251 15.5693 98.175 15.7115 98.2746 15.8288C98.3743 15.9461 98.57 16.0599 98.8655 16.1665V14.7197ZM99.8727 19.5294C100.382 19.4512 100.634 19.2237 100.634 18.8433V18.822C100.634 18.6372 100.581 18.4843 100.474 18.367C100.367 18.2497 100.168 18.1359 99.8727 18.0293V19.5294Z"
                    fill="#1B1B25"
                />
                <path
                    d="M88.9032 34.0932C88.9032 31.875 87.1023 30.0798 84.8849 30.0798C87.1058 30.0798 88.9032 28.2811 88.9032 26.0664C88.9032 28.2846 90.7042 30.0798 92.9215 30.0798C90.7006 30.0798 88.9032 31.8786 88.9032 34.0932Z"
                    fill="white"
                />
                <path
                    d="M136.12 54.2757C136.12 52.6476 134.8 51.3288 133.17 51.3288C134.8 51.3288 136.12 50.0099 136.12 48.3818C136.12 50.0099 137.441 51.3288 139.071 51.3288C137.441 51.3288 136.12 52.6476 136.12 54.2757Z"
                    fill="white"
                />
                <path
                    d="M116.825 68.4731C116.825 65.4799 114.395 63.052 111.398 63.052C114.395 63.052 116.825 60.624 116.825 57.6309C116.825 60.624 119.256 63.052 122.253 63.052C119.256 63.052 116.825 65.4799 116.825 68.4731Z"
                    fill="white"
                />
                <path
                    d="M135.564 26.6465C135.564 23.8418 133.286 21.5667 130.478 21.5667C133.286 21.5667 135.564 19.2916 135.564 16.4868C135.564 19.2916 137.842 21.5667 140.65 21.5667C137.842 21.5667 135.564 23.8418 135.564 26.6465Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M152.566 30.0765C152.566 28.5302 151.309 27.2753 149.761 27.2753C151.309 27.2753 152.566 26.0205 152.566 24.4741C152.566 26.0205 153.822 27.2753 155.37 27.2753C153.822 27.2753 152.566 28.5302 152.566 30.0765Z"
                    fill="white"
                />
                <path
                    d="M66.5932 20.7295H35.3436C32.1296 20.7295 29.5243 23.3316 29.5243 26.5416C29.5243 29.7517 32.1296 32.3538 35.3436 32.3538H61.0978L64.6392 35.578V32.3538H66.5932C69.8072 32.3538 72.4125 29.7517 72.4125 26.5416C72.4125 23.3316 69.8072 20.7295 66.5932 20.7295Z"
                    fill="#039D55"
                />
                <path
                    d="M38.1622 25.7403C38.5679 25.4025 38.8278 24.8942 38.8278 24.3219C38.8278 23.3052 38.002 22.4805 36.9841 22.4805C35.9662 22.4805 35.1404 23.3052 35.1404 24.3219C35.1404 24.8906 35.4003 25.4025 35.806 25.7403C34.4962 26.2202 33.5637 27.4715 33.5637 28.9467C33.5637 30.8343 40.408 30.8343 40.408 28.9467C40.408 27.475 39.472 26.2202 38.1657 25.7403H38.1622Z"
                    fill="#FFB54A"
                />
                <path
                    d="M66.9871 23.853H44.5963C44.4966 23.853 44.4183 23.7748 44.4183 23.6753C44.4183 23.5758 44.4966 23.4976 44.5963 23.4976H66.9871C67.0868 23.4976 67.1651 23.5758 67.1651 23.6753C67.1651 23.7748 67.0868 23.853 66.9871 23.853Z"
                    fill="white"
                />
                <path
                    d="M63.513 29.0996H44.5959C44.4963 29.0996 44.418 29.0214 44.418 28.9219C44.418 28.8223 44.4963 28.7441 44.5959 28.7441H63.513C63.6127 28.7441 63.691 28.8223 63.691 28.9219C63.691 29.0214 63.6127 29.0996 63.513 29.0996Z"
                    fill="white"
                />
                <path
                    d="M58.3583 26.6441H44.5914C44.4918 26.6441 44.4135 26.5659 44.4135 26.4663C44.4135 26.3668 44.4918 26.2886 44.5914 26.2886H58.3583C58.458 26.2886 58.5363 26.3668 58.5363 26.4663C58.5363 26.5659 58.458 26.6441 58.3583 26.6441Z"
                    fill="white"
                />
                <path
                    d="M66.9858 26.6441H60.0774C59.9777 26.6441 59.8994 26.5659 59.8994 26.4663C59.8994 26.3668 59.9777 26.2886 60.0774 26.2886H66.9858C67.0854 26.2886 67.1637 26.3668 67.1637 26.4663C67.1637 26.5659 67.0854 26.6441 66.9858 26.6441Z"
                    fill="white"
                />
                <path
                    d="M39.1982 28.4143C39.063 28.4143 38.9242 28.3609 38.821 28.2578L37.4791 26.9177C37.2692 26.7079 37.2692 26.3702 37.4791 26.164C37.6891 25.9543 38.0273 25.9543 38.2337 26.164L39.1982 27.1274L41.7858 24.543C41.9958 24.3333 42.3339 24.3333 42.5403 24.543C42.7503 24.7528 42.7503 25.0905 42.5403 25.2967L39.5755 28.2614C39.4723 28.3645 39.3335 28.4178 39.1982 28.4178V28.4143Z"
                    fill="white"
                />
                <path
                    d="M205.967 50.998H238.029C241.324 50.998 244.001 53.6677 244.001 56.9631C244.001 60.2584 241.328 62.9281 238.029 62.9281H211.605L207.971 66.2376V62.9281H205.967C202.672 62.9281 199.995 60.2584 199.995 56.9631C199.995 53.6677 202.668 50.998 205.967 50.998Z"
                    fill="#FFB54A"
                />
                <path
                    d="M237.311 56.086C237.716 55.7482 237.976 55.2399 237.976 54.6676C237.976 53.6509 237.15 52.8262 236.133 52.8262C235.115 52.8262 234.289 53.6509 234.289 54.6676C234.289 55.2363 234.549 55.7482 234.954 56.086C233.645 56.5659 232.712 57.8172 232.712 59.2924C232.712 61.18 239.556 61.18 239.556 59.2924C239.556 57.8207 238.62 56.5659 237.314 56.086H237.311Z"
                    fill="#039D55"
                />
                <path
                    d="M240.123 57.1124H239.24V56.2308C239.24 56.1348 239.162 56.0566 239.066 56.0566H238.258C238.161 56.0566 238.083 56.1348 238.083 56.2308V57.1124H237.201C237.104 57.1124 237.026 57.1906 237.026 57.2866V58.0936C237.026 58.1895 237.104 58.2677 237.201 58.2677H238.083V59.1493C238.083 59.2453 238.161 59.3235 238.258 59.3235H239.066C239.162 59.3235 239.24 59.2453 239.24 59.1493V58.2677H240.123C240.219 58.2677 240.297 58.1895 240.297 58.0936V57.2866C240.297 57.1906 240.219 57.1124 240.123 57.1124Z"
                    fill="white"
                />
                <path
                    d="M229.91 54.5567H207.519C207.419 54.5567 207.341 54.4784 207.341 54.3789C207.341 54.2794 207.419 54.2012 207.519 54.2012H229.91C230.009 54.2012 230.088 54.2794 230.088 54.3789C230.088 54.4784 230.009 54.5567 229.91 54.5567Z"
                    fill="white"
                />
                <path
                    d="M226.436 59.8032H207.519C207.419 59.8032 207.341 59.725 207.341 59.6255C207.341 59.526 207.419 59.4478 207.519 59.4478H226.436C226.536 59.4478 226.614 59.526 226.614 59.6255C226.614 59.725 226.536 59.8032 226.436 59.8032Z"
                    fill="white"
                />
                <path
                    d="M221.286 57.3428H207.519C207.419 57.3428 207.341 57.2646 207.341 57.165C207.341 57.0655 207.419 56.9873 207.519 56.9873H221.286C221.385 56.9873 221.464 57.0655 221.464 57.165C221.464 57.2646 221.385 57.3428 221.286 57.3428Z"
                    fill="white"
                />
                <path
                    d="M229.909 57.3428H223C222.901 57.3428 222.822 57.2646 222.822 57.165C222.822 57.0655 222.901 56.9873 223 56.9873H229.909C230.008 56.9873 230.087 57.0655 230.087 57.165C230.087 57.2646 230.008 57.3428 229.909 57.3428Z"
                    fill="white"
                />
                <path
                    d="M165.667 16.6226H187.752C190.022 16.6226 191.866 18.4604 191.866 20.7319C191.866 23.0035 190.026 24.8413 187.752 24.8413H165.667C163.396 24.8413 161.552 23.0035 161.552 20.7319C161.552 18.4604 163.393 16.6226 165.667 16.6226Z"
                    fill="#039D55"
                />
                <path
                    d="M185.263 19.377H168.139C168.04 19.377 167.961 19.2988 167.961 19.1992C167.961 19.0997 168.04 19.0215 168.139 19.0215H185.263C185.362 19.0215 185.441 19.0997 185.441 19.1992C185.441 19.2988 185.362 19.377 185.263 19.377Z"
                    fill="white"
                />
                <path
                    d="M182.603 22.4849H168.135C168.035 22.4849 167.957 22.4067 167.957 22.3071C167.957 22.2076 168.035 22.1294 168.135 22.1294H182.603C182.702 22.1294 182.781 22.2076 182.781 22.3071C182.781 22.4067 182.702 22.4849 182.603 22.4849Z"
                    fill="white"
                />
                <path
                    d="M178.663 21.0308H168.135C168.035 21.0308 167.957 20.9526 167.957 20.853C167.957 20.7535 168.035 20.6753 168.135 20.6753H178.663C178.762 20.6753 178.841 20.7535 178.841 20.853C178.841 20.9526 178.762 21.0308 178.663 21.0308Z"
                    fill="white"
                />
                <path
                    d="M185.262 21.0308H179.98C179.881 21.0308 179.802 20.9526 179.802 20.853C179.802 20.7535 179.881 20.6753 179.98 20.6753H185.262C185.362 20.6753 185.44 20.7535 185.44 20.853C185.44 20.9526 185.362 21.0308 185.262 21.0308Z"
                    fill="white"
                />
                <path
                    d="M15.9746 74.8604H35.6142C37.6323 74.8604 39.2731 76.4956 39.2731 78.5147C39.2731 80.5339 37.6358 82.1691 35.6142 82.1691H15.9746C13.9566 82.1691 12.3158 80.5339 12.3158 78.5147C12.3158 76.4956 13.953 74.8604 15.9746 74.8604Z"
                    fill="#FFB54A"
                />
                <path
                    d="M33.3978 77.3316H18.1716C18.072 77.3316 17.9937 77.2534 17.9937 77.1538C17.9937 77.0543 18.072 76.9761 18.1716 76.9761H33.3978C33.4975 76.9761 33.5758 77.0543 33.5758 77.1538C33.5758 77.2534 33.4975 77.3316 33.3978 77.3316Z"
                    fill="white"
                />
                <path
                    d="M31.0345 80.0928H18.1716C18.072 80.0928 17.9937 80.0146 17.9937 79.915C17.9937 79.8155 18.072 79.7373 18.1716 79.7373H31.0345C31.1342 79.7373 31.2125 79.8155 31.2125 79.915C31.2125 80.0146 31.1342 80.0928 31.0345 80.0928Z"
                    fill="white"
                />
                <path
                    d="M27.5323 78.7993H18.1716C18.072 78.7993 17.9937 78.7211 17.9937 78.6216C17.9937 78.5221 18.072 78.4438 18.1716 78.4438H27.5323C27.6319 78.4438 27.7102 78.5221 27.7102 78.6216C27.7102 78.7211 27.6319 78.7993 27.5323 78.7993Z"
                    fill="white"
                />
                <path
                    d="M33.3972 78.7993H28.6991C28.5994 78.7993 28.5211 78.7211 28.5211 78.6216C28.5211 78.5221 28.5994 78.4438 28.6991 78.4438H33.3972C33.4969 78.4438 33.5752 78.5221 33.5752 78.6216C33.5752 78.7211 33.4969 78.7993 33.3972 78.7993Z"
                    fill="white"
                />
                <path
                    d="M161.125 94.6113H126.231C126.131 94.6113 126.053 94.5331 126.053 94.4336C126.053 94.3341 126.131 94.2559 126.231 94.2559H161.125C161.225 94.2559 161.303 94.3341 161.303 94.4336C161.303 94.5331 161.225 94.6113 161.125 94.6113Z"
                    fill="white"
                />
                <path
                    d="M161.124 102.787H131.643C131.544 102.787 131.465 102.708 131.465 102.609C131.465 102.509 131.544 102.431 131.643 102.431H161.124C161.224 102.431 161.302 102.509 161.302 102.609C161.302 102.708 161.224 102.787 161.124 102.787Z"
                    fill="white"
                />
                <path
                    d="M161.126 98.9585H139.675C139.575 98.9585 139.497 98.8803 139.497 98.7808C139.497 98.6812 139.575 98.603 139.675 98.603H161.126C161.226 98.603 161.304 98.6812 161.304 98.7808C161.304 98.8803 161.226 98.9585 161.126 98.9585Z"
                    fill="white"
                />
                <path
                    d="M136.998 98.9585H126.231C126.131 98.9585 126.053 98.8803 126.053 98.7808C126.053 98.6812 126.131 98.603 126.231 98.603H136.998C137.097 98.603 137.176 98.6812 137.176 98.7808C137.176 98.8803 137.097 98.9585 136.998 98.9585Z"
                    fill="white"
                />
                <path
                    d="M121.661 107.582H86.7672C86.6675 107.582 86.5892 107.504 86.5892 107.404C86.5892 107.305 86.6675 107.227 86.7672 107.227H121.661C121.761 107.227 121.839 107.305 121.839 107.404C121.839 107.504 121.761 107.582 121.661 107.582Z"
                    fill="white"
                />
                <path
                    d="M116.248 115.757H86.7672C86.6675 115.757 86.5892 115.679 86.5892 115.58C86.5892 115.48 86.6675 115.402 86.7672 115.402H116.248C116.348 115.402 116.426 115.48 116.426 115.58C116.426 115.679 116.348 115.757 116.248 115.757Z"
                    fill="white"
                />
                <path
                    d="M108.218 111.929H86.7672C86.6675 111.929 86.5892 111.851 86.5892 111.751C86.5892 111.652 86.6675 111.574 86.7672 111.574H108.218C108.318 111.574 108.396 111.652 108.396 111.751C108.396 111.851 108.318 111.929 108.218 111.929Z"
                    fill="white"
                />
                <path
                    d="M121.661 111.929H110.895C110.795 111.929 110.717 111.851 110.717 111.751C110.717 111.652 110.795 111.574 110.895 111.574H121.661C121.761 111.574 121.839 111.652 121.839 111.751C121.839 111.851 121.761 111.929 121.661 111.929Z"
                    fill="white"
                />
                <path
                    d="M147.967 74.556L147.978 74.5168L153.131 56.6111L153.11 56.5934C153.341 56.1419 153.943 55.1679 155.171 54.3112C157.296 52.8324 157.548 50.3795 157.548 50.3795C158.684 49.2846 159.961 48.3462 161.118 47.2762C161.239 47.166 161.364 47.0415 161.399 46.8816C161.438 46.7038 161.357 46.519 161.253 46.3661C160.655 45.481 159.556 45.353 158.645 45.7618C158.111 46 157.63 46.3412 157.182 46.7145C156.968 46.8922 156.242 47.3792 156.021 47.7063L160.122 38.965C160.485 38.19 160.246 37.3013 159.591 36.9956C159.264 36.8427 158.89 36.8605 158.556 37.0169C158.342 37.1164 158.15 37.2729 157.986 37.4719C158 37.4079 158.007 37.3688 158.007 37.3688C153.206 33.3377 147.284 47.0593 147.284 47.0593L145.604 51.0229L131.346 77.4283C129.331 81.2604 130.883 85.9954 134.78 87.8937C134.837 87.9221 134.894 87.9435 134.951 87.9719C136.094 88.6295 137.421 89.0099 138.834 89.0099H166.895L172.942 74.6555L147.971 74.556H147.967Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.17"
                    d="M143.162 89.0046C142.251 88.9762 142.802 88.994 143.162 89.0046V89.0046Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M143.166 89.0029C143.294 89.0065 143.397 89.01 143.397 89.01C143.312 89.01 143.237 89.0065 143.166 89.0029Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M147.981 74.5177L147.166 77.3545C146.952 78.1401 146.71 78.9861 146.447 79.85L145.461 83.2768C145.325 83.7176 145.151 84.1335 144.948 84.5281C144.098 87.0663 143.4 89.0108 143.4 89.0108L153.49 74.5781C150.981 74.5781 150.404 74.5177 147.981 74.5142V74.5177Z"
                    fill="#FF887C"
                />
                <path
                    d="M152.042 48.602C152.006 48.602 151.967 48.5914 151.935 48.5665C151.857 48.5096 151.839 48.3959 151.896 48.3177C153.686 45.8933 156.096 47.2014 156.117 47.2157C156.202 47.2654 156.234 47.3721 156.185 47.4574C156.138 47.5427 156.028 47.5747 155.942 47.5249C155.854 47.4752 153.782 46.3589 152.18 48.5274C152.145 48.5736 152.091 48.5985 152.038 48.5985L152.042 48.602Z"
                    fill="#FB8E77"
                />
                <path
                    d="M158.089 37.4407C157.349 38.372 156.662 39.3496 156.05 40.3698C155.747 40.8782 155.469 41.4043 155.242 41.9446C155.014 42.4814 154.832 43.0573 154.861 43.5976V43.6083C154.868 43.7078 154.793 43.7896 154.694 43.7967C154.594 43.8038 154.512 43.7256 154.505 43.6296C154.505 43.6296 154.505 43.6296 154.505 43.6261C154.487 42.9649 154.704 42.3748 154.946 41.8202C155.195 41.2657 155.487 40.736 155.808 40.2241C156.448 39.2039 157.157 38.2334 157.925 37.3091C157.961 37.2629 158.029 37.2594 158.075 37.2949C158.121 37.3305 158.125 37.398 158.089 37.4407Z"
                    fill="#FB8E77"
                />
                <path
                    d="M156.854 36.9326C156.384 37.2561 155.964 37.6827 155.587 38.127C155.21 38.5749 154.879 39.062 154.58 39.5667C154.288 40.0751 154.028 40.6048 153.811 41.1486C153.694 41.4188 153.608 41.6996 153.505 41.9734L153.249 42.8159V42.8265C153.217 42.919 153.117 42.9723 153.025 42.9438C152.932 42.9154 152.879 42.8159 152.907 42.7234L153.185 41.8667C153.295 41.5859 153.391 41.3015 153.512 41.0278C153.747 40.4732 154.021 39.9364 154.331 39.421C154.648 38.9091 154.996 38.415 155.391 37.96C155.794 37.5085 156.221 37.0855 156.737 36.7407C156.787 36.7087 156.858 36.7193 156.89 36.7726C156.922 36.8224 156.911 36.89 156.861 36.9255L156.854 36.9326Z"
                    fill="#FB8E77"
                />
                <path
                    d="M154.912 37.0712C154.232 37.7822 153.595 38.5536 153.047 39.3712C152.776 39.7835 152.516 40.203 152.313 40.6438C152.107 41.0846 151.94 41.5432 151.865 42.0089C151.851 42.1084 151.758 42.1759 151.662 42.1617C151.566 42.1475 151.498 42.0551 151.513 41.9591C151.513 41.9591 151.513 41.9591 151.513 41.9555C151.609 41.4401 151.801 40.9602 152.025 40.5052C152.249 40.0502 152.527 39.6271 152.815 39.2112C153.395 38.3901 154.054 37.6329 154.766 36.9219C154.805 36.8828 154.872 36.8828 154.912 36.9219C154.951 36.961 154.951 37.025 154.912 37.0677V37.0712Z"
                    fill="#FB8E77"
                />
                <path
                    d="M212.73 100.627L205.847 81.8863C205.028 77.7734 201.109 74.6558 196.397 74.6558L177.17 74.5029L155.509 74.5847V89.0067H162.232L158.762 126.627L206.462 126.898L206.196 101.424L212.73 100.624V100.627Z"
                    fill="#039D55"
                />
                <path
                    opacity="0.05"
                    d="M177.134 74.6673L177.173 74.5073L155.511 74.5891V89.011H162.235L162.27 88.6307C162.27 81.0198 168.898 74.8344 177.137 74.6673H177.134Z"
                    fill="#1B1B25"
                />
                <path
                    opacity="0.18"
                    d="M149.761 53.7915C149.761 53.7915 150.978 64.1041 151.049 63.8588C151.12 63.61 153.135 56.6105 153.135 56.6105L149.761 53.7915Z"
                    fill="#FF887C"
                />
                <path
                    d="M178.152 106.007L176.333 96.843L174.927 89.7725C174.763 88.9406 173.945 88.3968 173.112 88.5603L166.079 89.9538C165.246 90.1173 164.702 90.9349 164.865 91.7667L166.278 98.8835L167.399 104.529L168.09 108.002C168.254 108.834 169.072 109.377 169.905 109.214L174.059 108.389L176.938 107.82C177.771 107.657 178.315 106.839 178.152 106.007Z"
                    fill="#1B1B25"
                />
                <path
                    d="M215.579 114.454L212.408 100.665L197.993 102.428L198.784 105.937L198.709 105.919L183.038 102.044L183.023 102.062C182.593 101.845 181.778 101.33 181.062 100.263C179.749 98.3011 177.542 98.2478 177.542 98.2478C177.119 97.8034 176.72 97.3271 176.329 96.8472L176.695 98.6957L176.603 98.7454C175.606 99.2716 174.481 99.5062 173.357 99.4173C171.278 99.2538 167.879 98.9907 166.466 98.8805C166.035 98.8485 165.623 99.076 165.434 99.4671C163.416 103.701 172.075 107.576 174.054 108.393C174.079 108.404 174.101 108.411 174.125 108.422C174.154 108.432 174.182 108.443 174.207 108.454C174.236 108.464 174.257 108.475 174.282 108.486C174.303 108.496 174.328 108.503 174.346 108.511C174.371 108.521 174.389 108.528 174.407 108.535C174.414 108.535 174.424 108.543 174.428 108.546C174.446 108.553 174.456 108.557 174.456 108.557L177.845 109.826L204.674 123.018C204.923 123.139 205.176 123.242 205.429 123.331C206.731 123.924 208.226 124.12 209.728 123.775C213.917 122.815 216.533 118.642 215.572 114.461L215.579 114.454Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.17"
                    d="M214.558 110.007L197.994 102.424C198.545 104.831 198.225 103.768 198.713 105.915L199.841 106.192C204.61 106.512 214.562 110.007 214.562 110.007H214.558Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.35"
                    d="M196.656 102.603C196.574 102.603 196.499 102.546 196.481 102.461L194.41 92.4468C194.389 92.3508 194.453 92.2548 194.549 92.237C194.641 92.2157 194.741 92.2797 194.759 92.3757L196.795 102.226L203.763 101.341C203.86 101.327 203.949 101.398 203.963 101.494C203.977 101.59 203.906 101.679 203.81 101.693L196.677 102.599C196.677 102.599 196.663 102.599 196.656 102.599V102.603Z"
                    fill="#1B1B25"
                />
                <path
                    opacity="0.17"
                    d="M214.671 110.582C214.685 110.649 214.696 110.702 214.699 110.724C214.699 110.71 214.689 110.663 214.671 110.582Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M214.56 110.008C214.56 110.008 214.599 110.2 214.635 110.389C214.613 110.289 214.592 110.168 214.56 110.008Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M214.635 110.389C214.649 110.467 214.663 110.531 214.674 110.577C214.663 110.52 214.649 110.456 214.635 110.389Z"
                    fill="#FF887C"
                />
                <path
                    d="M195.024 37.5279C194.586 34.5099 191.828 32.3628 188.77 32.7076C187.959 32.8 187.208 33.0595 186.546 33.447C185.563 31.8402 183.709 30.8555 181.712 31.0795C180.57 31.2074 179.566 31.7158 178.801 32.4552C177.698 31.9042 176.431 31.6482 175.114 31.7975C171.494 32.2063 168.892 35.4697 169.302 39.0814C169.494 40.7735 170.312 42.2381 171.498 43.2796L170.156 50.432C169.771 52.4867 171.124 54.4596 173.181 54.8435L189.062 57.8118C191.119 58.1957 193.095 56.8449 193.479 54.7902L196.081 40.9086C196.319 39.6288 195.885 38.3775 195.02 37.5244L195.024 37.5279Z"
                    fill="#1B1B25"
                />
                <path
                    d="M171.875 41.4425C171.814 41.4425 171.757 41.414 171.725 41.3607C168.888 36.8781 172.796 34.0022 172.836 33.9738C172.914 33.9169 173.028 33.9347 173.085 34.0129C173.142 34.0911 173.124 34.2048 173.046 34.2617C172.896 34.3719 169.372 36.974 172.028 41.1723C172.081 41.2541 172.056 41.3643 171.971 41.4176C171.942 41.4354 171.907 41.446 171.875 41.446V41.4425Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M192.454 51.5492L192.105 51.4852L188.599 43.9596C187.738 43.8352 186.926 43.5188 186.229 43.0425C185.556 43.7712 184.631 44.2725 183.57 44.3898C182.292 44.5355 181.082 44.0983 180.203 43.2949C179.224 44.1516 177.989 44.7346 176.597 44.891C175.007 45.0723 173.483 44.667 172.245 43.8565L169.803 56.885C169.465 58.6838 169.835 60.4505 170.707 61.908C171.575 64.0515 173.44 65.7365 175.843 66.2875V74.8938C175.843 77.8834 178.292 80.3291 181.285 80.3291H183C185.994 80.3291 188.442 77.8834 188.442 74.8938V65.1251C189.325 64.1582 189.962 62.946 190.222 61.5632L190.667 59.185L191.016 59.249C193.077 59.6329 195.08 58.2643 195.465 56.206L195.504 55.9963C195.888 53.938 194.518 51.9367 192.457 51.5528L192.454 51.5492Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.32"
                    d="M189.854 58.8789L189.538 60.5746C188.804 64.492 185.032 67.0692 181.109 66.3369L175.568 65.2989C173.45 64.9043 171.727 63.6175 170.702 61.9041C171.606 64.1365 173.589 65.8784 176.134 66.3547L176.354 66.3974C177.234 68.221 179.102 69.4901 181.252 69.4901H182.989C185.555 69.4901 187.719 67.6878 188.281 65.2883C189.246 64.2929 189.936 63.0203 190.21 61.5592L190.655 59.1811L189.847 58.8789H189.854Z"
                    fill="#FF887C"
                />
                <path
                    d="M192.762 56.6515C192.723 56.6515 192.683 56.6409 192.651 56.6124L191.267 55.5389C191.224 55.5069 191.199 55.4571 191.199 55.4074C191.199 55.354 191.217 55.3043 191.256 55.2687L192.965 53.6584C193.036 53.5908 193.15 53.5944 193.217 53.6655C193.285 53.7366 193.281 53.8503 193.21 53.9179L191.655 55.386L192.876 56.3316C192.954 56.392 192.968 56.5022 192.908 56.5804C192.872 56.6267 192.819 56.648 192.769 56.648L192.762 56.6515Z"
                    fill="#FB8E77"
                />
                <path
                    d="M183.953 50.0361C183.686 50.029 183.412 49.8655 183.134 49.7268C182.86 49.5775 182.583 49.4389 182.334 49.3216C182.088 49.2078 181.8 49.0834 181.508 48.9697C181.223 48.8488 180.921 48.7421 180.746 48.5431C180.575 48.3547 180.611 48.0596 181.006 47.8606C181.383 47.665 182.156 47.6153 182.974 47.9956C183.789 48.376 184.241 48.9945 184.323 49.4069C184.416 49.8335 184.202 50.0468 183.946 50.0361H183.953Z"
                    fill="#1B1B25"
                />
                <path
                    d="M172.631 49.0627C172.862 49.1907 173.179 49.2084 173.489 49.2404C173.798 49.2689 174.108 49.3009 174.378 49.34C174.649 49.3791 174.959 49.4288 175.261 49.4893C175.567 49.5426 175.877 49.6137 176.13 49.5533C176.372 49.4999 176.5 49.2618 176.268 48.9205C176.051 48.5863 175.421 48.1704 174.528 48.0425C173.635 47.918 172.93 48.1491 172.642 48.4122C172.335 48.6823 172.407 48.9454 172.627 49.0627H172.631Z"
                    fill="#1B1B25"
                />
                <path
                    d="M181.338 53.0736L181.359 53.0775C181.599 53.1224 181.829 52.9647 181.874 52.7254L181.98 52.1629C182.024 51.9236 181.867 51.6933 181.627 51.6485L181.606 51.6445C181.367 51.5997 181.136 51.7574 181.091 51.9966L180.986 52.5592C180.941 52.7985 181.098 53.0288 181.338 53.0736Z"
                    fill="#1B1B25"
                />
                <path
                    d="M173.665 51.8368L173.686 51.8407C173.926 51.8855 174.156 51.7279 174.201 51.4886L174.307 50.9261C174.352 50.6868 174.194 50.4565 173.954 50.4116L173.933 50.4077C173.694 50.3629 173.463 50.5205 173.418 50.7598L173.313 51.3224C173.268 51.5616 173.426 51.792 173.665 51.8368Z"
                    fill="#1B1B25"
                />
                <path
                    opacity="0.17"
                    d="M183.231 55.282L181.657 55.1051C181.356 55.0713 181.143 54.8005 181.176 54.5038L181.18 54.472C181.214 54.1717 181.485 53.9589 181.782 53.9923L183.356 54.1692C183.657 54.203 183.87 54.4738 183.836 54.7705L183.833 54.8023C183.799 55.1026 183.528 55.3153 183.231 55.282Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M172.841 53.6487L171.268 53.4718C170.967 53.438 170.754 53.1672 170.787 52.8705L170.791 52.8387C170.825 52.5384 171.096 52.3256 171.393 52.359L172.967 52.5359C173.267 52.5697 173.48 52.8405 173.447 53.1372L173.444 53.1655C173.41 53.4657 173.139 53.6785 172.842 53.6451L172.841 53.6487Z"
                    fill="#FF887C"
                />
                <path
                    d="M175.855 61.5242C175.802 61.5242 175.745 61.4993 175.713 61.4496C175.656 61.3713 175.673 61.2576 175.752 61.2007C176.499 60.6568 177.332 60.9625 177.67 61.2007C177.752 61.2576 177.77 61.3678 177.713 61.446C177.656 61.5278 177.546 61.5455 177.464 61.4887C177.432 61.4673 176.681 60.959 175.958 61.4887C175.926 61.51 175.891 61.5242 175.855 61.5242Z"
                    fill="#FB8E77"
                />
                <path
                    d="M177.058 56.4731L181.219 55.8794L180.763 57.3227C180.471 58.2469 179.613 58.8761 178.642 58.8761C177.887 58.8761 177.254 58.3073 177.172 57.5573L177.054 56.4731H177.058Z"
                    fill="white"
                />
                <path
                    d="M178.136 54.9994C178.136 54.9994 178.108 54.9994 178.09 54.9923L176.798 54.6582C176.25 54.516 175.808 54.1356 175.588 53.6166C175.367 53.0976 175.396 52.5146 175.67 52.0241L177.634 48.4905C177.684 48.4052 177.791 48.3732 177.876 48.423C177.962 48.4692 177.994 48.5794 177.944 48.6647L175.979 52.1982C175.759 52.5964 175.734 53.0621 175.915 53.4815C176.093 53.8974 176.449 54.2032 176.89 54.3169L178.182 54.6511C178.279 54.676 178.336 54.7719 178.311 54.8679C178.289 54.9497 178.218 54.9994 178.14 54.9994H178.136Z"
                    fill="#FB8E77"
                />
                <path
                    d="M117.692 80.5597L103.434 54.1544L101.754 50.1907C101.754 50.1907 95.8319 36.4655 91.0305 40.5002C91.0305 40.5002 91.0377 40.5393 91.0519 40.6033C90.8882 40.4043 90.696 40.2479 90.4824 40.1483C90.1479 39.9919 89.7741 39.9741 89.4467 40.127C88.7918 40.4327 88.5533 41.3179 88.9164 42.0964L93.0166 50.8377C92.7959 50.5142 92.0698 50.0236 91.8563 49.8459C91.4078 49.4726 90.9309 49.1314 90.3934 48.8932C89.4787 48.4844 88.3825 48.6124 87.7846 49.4975C87.6813 49.6504 87.5995 49.8317 87.6386 50.013C87.6742 50.1729 87.7988 50.2974 87.9198 50.4076C89.0765 51.4776 90.3578 52.416 91.4897 53.5109C91.4897 53.5109 91.7424 55.9638 93.8672 57.4426C95.0951 58.2993 95.6966 59.2698 95.928 59.7248L95.9066 59.7426L101.071 77.6874L93.5291 77.7869V92.1413H110.211C111.628 92.1413 112.955 91.7609 114.098 91.0997C114.151 91.0749 114.208 91.05 114.261 91.0251C118.155 89.1268 119.71 84.3918 117.696 80.5597H117.692Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.17"
                    d="M105.638 92.1411C105.638 92.1411 101.762 81.7255 101.097 77.6445C98.5268 77.6445 98.1388 77.7583 95.5691 77.7583L105.638 92.1376V92.1411Z"
                    fill="#FF887C"
                />
                <path
                    d="M96.9917 51.7337C96.9384 51.7337 96.885 51.7089 96.8494 51.6626C95.2477 49.4942 93.1763 50.6104 93.0873 50.6602C93.0019 50.7064 92.8951 50.678 92.8453 50.5926C92.799 50.5073 92.8275 50.4007 92.9129 50.3509C92.9378 50.3367 95.3438 49.0285 97.1341 51.4529C97.1911 51.5311 97.1768 51.6449 97.095 51.7017C97.0629 51.7266 97.0273 51.7373 96.9882 51.7373L96.9917 51.7337Z"
                    fill="#FB8E77"
                />
                <path
                    d="M91.1013 40.4263C91.532 40.8564 91.927 41.315 92.3008 41.7914C92.6709 42.2677 93.0197 42.7654 93.3329 43.2879C93.639 43.8141 93.9131 44.3579 94.1302 44.9303C94.3366 45.5062 94.4825 46.1105 94.5288 46.7326C94.5359 46.8321 94.4647 46.9174 94.3651 46.9245C94.2654 46.9316 94.18 46.8605 94.1729 46.761V46.7539C94.1373 46.1745 94.0127 45.6021 93.8276 45.044C93.6283 44.4895 93.3756 43.9527 93.0873 43.4337C92.7919 42.9182 92.4609 42.4241 92.105 41.9442C91.7455 41.4679 91.3647 41.0057 90.9554 40.5792C90.9162 40.5329 90.9162 40.469 90.9554 40.4263C90.9981 40.3872 91.0622 40.3872 91.1049 40.4263H91.1013Z"
                    fill="#FB8E77"
                />
                <path
                    d="M92.3047 39.7431C92.8848 40.0417 93.3119 40.4897 93.707 40.9589C94.0985 41.4317 94.4366 41.9471 94.7285 42.4804C95.031 43.0136 95.2801 43.5681 95.5186 44.1298L95.8425 44.983L96.1308 45.8503C96.1628 45.9428 96.1094 46.0459 96.0169 46.0743C95.9244 46.1063 95.8211 46.053 95.7927 45.9605V45.9534L95.5222 45.0967L95.2196 44.2507C94.9954 43.6961 94.7641 43.1451 94.4758 42.619C94.2017 42.0893 93.8778 41.5845 93.5077 41.1189C93.1411 40.6603 92.7104 40.2124 92.2157 39.9458L92.1979 39.9351C92.1445 39.9067 92.1232 39.8391 92.1552 39.7858C92.1837 39.7325 92.2477 39.7147 92.3011 39.7396L92.3047 39.7431Z"
                    fill="#FB8E77"
                />
                <path
                    d="M94.2595 40.0446C94.6581 40.3681 95.014 40.7236 95.345 41.1039C95.6796 41.4843 95.9857 41.886 96.2597 42.309C96.5374 42.732 96.7865 43.1729 96.9929 43.6385C97.21 44.0971 97.3702 44.5806 97.5197 45.0676C97.5482 45.16 97.4948 45.2595 97.4022 45.288C97.3097 45.3164 97.21 45.2631 97.1816 45.1671V45.1564C97.0499 44.6872 96.9075 44.2144 96.7082 43.7665C96.5196 43.315 96.2882 42.8778 96.0284 42.4619C95.7721 42.0424 95.4838 41.6407 95.1671 41.2639C94.8539 40.8871 94.5086 40.5245 94.1385 40.2117H94.1349C94.0922 40.1726 94.0851 40.105 94.1242 40.0624C94.1598 40.0197 94.2239 40.0126 94.2666 40.0482L94.2595 40.0446Z"
                    fill="#FB8E77"
                />
                <path
                    opacity="0.18"
                    d="M95.2582 58.7268L100.768 58.0479L97.3616 64.8163C97.3616 64.8163 96.3473 59.7826 95.2582 58.7268Z"
                    fill="#FF887C"
                />
                <path
                    d="M73.1177 77.7859V77.7931C73.0322 77.7931 72.9504 77.7859 72.865 77.7859H55.4534C51.6736 77.7859 48.4489 80.157 47.1854 83.4879L47.1605 83.559C47.1569 83.5697 47.1534 83.5803 47.1463 83.5945L39.7432 103.754L46.616 104.593V126.981H84.0266L86.8241 92.1368H93.3303V77.7148L73.1177 77.7859Z"
                    fill="white"
                />
                <path
                    opacity="0.05"
                    d="M93.5262 77.7148L73.6517 77.7966C81.1047 78.1094 87.0485 84.238 87.0485 91.7564L87.0165 92.1368H93.5227V77.7148H93.5262Z"
                    fill="#1B1B25"
                />
                <path
                    d="M86.5818 93.0871L79.5489 91.6936C78.716 91.5301 77.901 92.074 77.7337 92.9058L76.3278 99.9763L74.509 109.141C74.3453 109.973 74.8899 110.787 75.7227 110.954L78.6021 111.522L82.7557 112.347C83.5885 112.511 84.4036 111.967 84.5709 111.135L85.2614 107.662L86.3825 102.017L87.7955 94.9C87.9592 94.0682 87.4147 93.2541 86.5818 93.0871Z"
                    fill="#1B1B25"
                />
                <path
                    d="M87.3184 102.525C87.2294 102.34 87.0906 102.195 86.9233 102.095C86.8948 102.052 86.8699 102.006 86.8379 101.964C86.8379 101.964 86.7738 101.971 86.6706 101.985C86.5496 101.949 86.4179 101.932 86.2898 101.942C84.8768 102.052 81.4777 102.316 79.3992 102.479C78.2745 102.568 77.1498 102.333 76.1532 101.807L75.9859 101.718L76.3312 99.98C75.9574 100.435 75.5802 100.886 75.1815 101.309C74.9787 101.32 73.8184 101.423 72.7328 102.23C72.3306 102.515 71.9356 102.891 71.5974 103.393C71.1739 104.025 70.7148 104.463 70.3232 104.758C70.0919 104.925 69.889 105.042 69.736 105.117L69.7217 105.099L54.0506 108.974L53.9795 108.991L54.7732 105.469L40.3513 103.723L37.1801 117.512C36.2191 121.696 38.8351 125.866 43.0243 126.826C44.5263 127.171 46.0247 126.975 47.3238 126.382C47.5765 126.293 47.8292 126.186 48.0783 126.069L74.6049 113.026L78.1997 111.679C78.1997 111.679 78.3457 111.622 78.5984 111.519L78.545 111.508C80.1858 110.84 89.3863 106.869 87.3148 102.518L87.3184 102.525Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.17"
                    d="M37.9947 113.698C37.9804 113.773 37.9697 113.819 37.9662 113.84C37.9697 113.816 37.9804 113.762 37.9947 113.698Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M53.9501 109.049C54.274 107.555 54.1815 107.683 54.6726 105.543L38.1046 113.144C38.1046 113.144 39.7454 112.65 42.0126 112.049C42.2226 111.971 42.4361 111.903 42.6568 111.843L53.9501 109.052V109.049Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M38.0371 113.495C38.0228 113.566 38.0086 113.637 37.9979 113.697C38.0086 113.644 38.0228 113.576 38.0371 113.495Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M37.9692 113.841C37.9652 113.865 37.9652 113.865 37.9692 113.841V113.841Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M38.1077 113.141C38.0792 113.287 38.0579 113.397 38.0365 113.497C38.0721 113.319 38.1077 113.141 38.1077 113.141Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.35"
                    d="M56.0122 105.717C56.0122 105.717 55.998 105.717 55.9909 105.717L52.8446 105.33C52.7485 105.319 52.6773 105.23 52.6915 105.131C52.7022 105.035 52.7947 104.964 52.8908 104.978L55.8663 105.344L57.5213 94.7899C57.5356 94.6939 57.6281 94.6263 57.7242 94.6406C57.8203 94.6548 57.8879 94.7472 57.8737 94.8432L56.1902 105.568C56.176 105.657 56.1012 105.717 56.0158 105.717H56.0122Z"
                    fill="#1B1B25"
                />
                <path
                    opacity="0.08"
                    d="M59.6838 107.569L66.788 107.391C68.112 107.565 70.2226 106.371 69.977 105.059L59.6838 107.569Z"
                    fill="#FF887C"
                />
                <path
                    d="M82.0945 73.2478L79.6778 56.8281C79.4144 55.0293 78.8912 53.3337 78.1544 51.766L79.4642 51.5562C79.4642 51.5562 78.5424 38.2292 63.5796 41.4107C62.1061 41.2579 60.5899 41.2828 59.0559 41.5103C51.7844 42.5767 46.7589 49.3274 47.8266 56.5899L49.2361 66.1595C50.3038 73.422 57.0627 78.4414 64.3341 77.375L80.8203 74.9542C81.646 74.8333 82.2155 74.069 82.0945 73.2443V73.2478Z"
                    fill="#1B1B25"
                />
                <path
                    d="M72.1681 51.0338C72.0792 51.0338 72.0044 50.9698 71.9902 50.8809C71.9759 50.7849 72.0436 50.6925 72.1432 50.6819L76.9552 50.0242C76.9944 50.0207 77.03 49.9993 77.0513 49.9673C77.0656 49.9496 77.0834 49.914 77.0763 49.8642C76.2968 45.5309 72.3034 43.5331 72.2607 43.5118C72.1717 43.4691 72.1361 43.3625 72.1788 43.2736C72.2215 43.1847 72.3283 43.1492 72.4173 43.1918C72.46 43.2131 76.6136 45.2856 77.4251 49.8003C77.45 49.9318 77.4179 50.0633 77.3396 50.1735C77.2613 50.2837 77.1368 50.3584 77.0051 50.3761L72.193 51.0338C72.193 51.0338 72.1752 51.0338 72.1681 51.0338Z"
                    fill="#FCF0E3"
                />
                <path
                    d="M76.8024 51.9833L63.6299 54.0984L60.4337 49.374C61.0602 54.6423 57.17 58.0478 57.17 58.0478C57.17 58.0478 57.1308 57.9945 57.0596 57.895L56.9493 57.9163C54.8885 58.3002 53.5182 60.3016 53.9026 62.3598C54.287 64.4181 56.2909 65.7867 58.3516 65.4028L58.6043 65.3566C59.0563 67.3295 60.0707 69.0429 61.4552 70.3404V78.7725C61.4552 81.7621 63.904 84.2078 66.8972 84.2078C69.8905 84.2078 72.3392 81.7621 72.3392 78.7725V72.1143C74.5068 71.1189 76.2045 69.3771 77.1726 67.2726C77.1726 67.2726 77.1762 67.2655 77.1797 67.262C78.3578 65.2926 78.849 62.9037 78.3934 60.4687L76.8024 51.9833Z"
                    fill="#FEC29E"
                />
                <path
                    opacity="0.32"
                    d="M70.5885 71.8555C65.7088 72.7691 60.9965 69.8862 59.5016 65.2898C59.4518 65.1404 58.594 65.336 58.6154 65.4284C59.0781 67.3835 60.1031 69.0756 61.4841 70.3625C61.7404 73.1175 64.0752 75.2966 66.9012 75.2966C68.9904 75.2966 70.8092 74.1022 71.7203 72.3674C74.1868 71.4325 76.123 69.5662 77.1801 67.2591C75.792 69.5804 73.4572 71.3152 70.5885 71.852V71.8555Z"
                    fill="#FF887C"
                />
                <path
                    d="M56.5542 62.9024C56.5009 62.9024 56.4475 62.8776 56.4119 62.8349C56.3514 62.7567 56.3656 62.6465 56.4439 62.5861L57.6291 61.6689L56.12 60.247C56.0488 60.1794 56.0453 60.0657 56.1129 59.9946C56.1805 59.9235 56.2944 59.9199 56.3656 59.9875L58.0277 61.5552C58.0669 61.5907 58.0847 61.6405 58.0847 61.6938C58.0847 61.7471 58.0562 61.7933 58.0171 61.8253L56.6681 62.8704C56.6361 62.8953 56.597 62.9095 56.5578 62.9095L56.5542 62.9024Z"
                    fill="#FB8E77"
                />
                <path
                    d="M66.0333 56.4226C66.1935 56.419 66.3572 56.323 66.5174 56.2377C66.6811 56.1489 66.8448 56.0671 66.9907 55.996C67.1367 55.9285 67.3075 55.8538 67.4819 55.7863C67.6527 55.7152 67.8307 55.6512 67.9339 55.5339C68.0336 55.4237 68.0158 55.2459 67.7773 55.1286C67.5531 55.0113 67.0939 54.9829 66.6099 55.2068C66.1258 55.4343 65.8589 55.8005 65.8091 56.0458C65.7521 56.2982 65.8803 56.4261 66.0333 56.419V56.4226Z"
                    fill="#1B1B25"
                />
                <path
                    d="M75.4715 54.78C75.3185 54.8191 75.1334 54.7729 74.9554 54.7373C74.7739 54.6982 74.5924 54.6627 74.4322 54.6378C74.2721 54.6129 74.087 54.5916 73.9055 54.5738C73.724 54.5525 73.5318 54.5418 73.4001 54.4565C73.2719 54.3783 73.2435 54.2041 73.4357 54.0228C73.6207 53.8486 74.0514 53.6958 74.5817 53.7775C75.1085 53.8629 75.468 54.1401 75.5819 54.3605C75.7064 54.588 75.6174 54.7445 75.4715 54.78Z"
                    fill="#1B1B25"
                />
                <path
                    d="M70.1388 63.7764C68.6796 63.7764 67.7044 62.6317 67.6937 62.6175C67.6296 62.5429 67.6403 62.4291 67.715 62.3687C67.7898 62.3047 67.9037 62.3154 67.9642 62.39C68.0211 62.4575 69.3701 64.0323 71.2564 63.1614C71.3454 63.1187 71.4522 63.1614 71.4913 63.2467C71.534 63.3356 71.4913 63.4422 71.4059 63.4813C70.9539 63.6911 70.5268 63.7728 70.1353 63.7728L70.1388 63.7764Z"
                    fill="#FB8E77"
                />
                <path
                    d="M71.2013 61.297C71.1194 61.297 71.0447 61.2366 71.0269 61.1548C71.0091 61.0588 71.0696 60.9664 71.1657 60.9451L72.4185 60.6998C73.198 60.5469 73.7034 59.7898 73.5504 59.0148C73.4934 58.734 73.2229 58.5527 72.9417 58.606C72.2833 58.734 71.6426 58.3074 71.5145 57.6497L71.212 56.1176C71.1942 56.0216 71.2547 55.9292 71.3508 55.9079C71.4469 55.8901 71.5394 55.9505 71.5608 56.0465L71.8633 57.5787C71.9558 58.0443 72.4079 58.3465 72.8741 58.2541C73.1055 58.2079 73.3368 58.2541 73.5326 58.3856C73.7283 58.5171 73.86 58.7126 73.9027 58.9437C74.0949 59.9142 73.4614 60.8562 72.4897 61.0482L71.2369 61.2935C71.2369 61.2935 71.212 61.2935 71.2013 61.2935V61.297Z"
                    fill="#FB8E77"
                />
                <path
                    d="M67.6545 59.4184C67.416 59.4646 67.1846 59.3047 67.1419 59.0665L67.0423 58.5404C66.996 58.3022 67.1562 58.0711 67.3946 58.0285C67.6331 57.9823 67.8644 58.1422 67.9071 58.3804L68.0068 58.9065C68.0531 59.1447 67.8929 59.3757 67.6545 59.4184Z"
                    fill="#1B1B25"
                />
                <path
                    d="M75.1183 58.2109C74.8799 58.2571 74.6485 58.0971 74.6058 57.859L74.5061 57.3328C74.4599 57.0947 74.62 56.8636 74.8585 56.8209C75.097 56.7747 75.3283 56.9347 75.371 57.1729L75.4707 57.699C75.5169 57.9372 75.3568 58.1682 75.1183 58.2109Z"
                    fill="#1B1B25"
                />
                <path
                    opacity="0.17"
                    d="M67.3459 61.4037L65.8439 61.5707C65.545 61.6027 65.2745 61.3895 65.2424 61.0908C65.2104 60.7922 65.424 60.5221 65.7229 60.4901L67.2249 60.323C67.5239 60.291 67.7944 60.5043 67.8264 60.8029C67.8584 61.1015 67.6449 61.3717 67.3459 61.4037Z"
                    fill="#FF887C"
                />
                <path
                    opacity="0.17"
                    d="M77.4513 59.8133L75.9493 59.9804C75.6503 60.0124 75.3798 59.7991 75.3478 59.5005C75.3158 59.2019 75.5293 58.9317 75.8283 58.8997L77.3302 58.7327C77.6292 58.7007 77.8997 58.914 77.9318 59.2126C77.9638 59.5112 77.7502 59.7813 77.4513 59.8133Z"
                    fill="#FF887C"
                />
                <path
                    d="M72.997 67.645C72.9614 67.645 72.9223 67.6344 72.8938 67.6095C72.1926 67.0976 71.4665 67.5917 71.4345 67.6095C71.3527 67.6664 71.2423 67.645 71.1854 67.5668C71.1284 67.4851 71.1498 67.3749 71.2281 67.318C71.5591 67.0869 72.3741 66.7883 73.1002 67.318C73.1785 67.3749 73.1963 67.4886 73.1394 67.5668C73.1038 67.6131 73.0504 67.6415 72.997 67.6415V67.645Z"
                    fill="#FB8E77"
                />
            </g>
            <defs>
                <clipPath id="clip0_3039_9752">
                    <rect width="244" height="127" fill="white" />
                </clipPath>
            </defs>
        </svg>
    )
}

export default ReferAFriend
